/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ams.wrappers;

import net.accelbyte.sdk.api.ams.models.ApiDSHistoryList;
import net.accelbyte.sdk.api.ams.models.ApiFleetServerConnectionInfoResponse;
import net.accelbyte.sdk.api.ams.models.ApiFleetServerHistoryResponse;
import net.accelbyte.sdk.api.ams.models.ApiFleetServerInfoResponse;
import net.accelbyte.sdk.api.ams.operations.servers.FleetServerConnectionInfo;
import net.accelbyte.sdk.api.ams.operations.servers.FleetServerHistory;
import net.accelbyte.sdk.api.ams.operations.servers.FleetServerInfo;
import net.accelbyte.sdk.api.ams.operations.servers.ServerHistory;
import net.accelbyte.sdk.core.HttpResponse;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.RequestRunner;

public class Servers {
    private RequestRunner sdk;
    private String customBasePath = "";

    public Servers(RequestRunner sdk) {
        this.sdk = sdk;
        String configCustomBasePath = sdk.getSdkConfiguration().getConfigRepository().getCustomServiceBasePath("ams");
        if (!configCustomBasePath.equals("")) {
            this.customBasePath = configCustomBasePath;
        }
    }

    public Servers(RequestRunner sdk, String customBasePath) {
        this.sdk = sdk;
        this.customBasePath = customBasePath;
    }

    public ApiDSHistoryList fleetServerHistory(FleetServerHistory input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public ApiFleetServerInfoResponse fleetServerInfo(FleetServerInfo input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public ApiFleetServerConnectionInfoResponse fleetServerConnectionInfo(FleetServerConnectionInfo input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public ApiFleetServerHistoryResponse serverHistory(ServerHistory input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }
}

