/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ams.wrappers;

import net.accelbyte.sdk.api.ams.models.ApiArtifactListResponse;
import net.accelbyte.sdk.api.ams.models.ApiArtifactURLResponse;
import net.accelbyte.sdk.api.ams.models.ApiArtifactUsageResponse;
import net.accelbyte.sdk.api.ams.models.ApiFleetArtifactsSampleRules;
import net.accelbyte.sdk.api.ams.operations.artifacts.ArtifactBulkDelete;
import net.accelbyte.sdk.api.ams.operations.artifacts.ArtifactDelete;
import net.accelbyte.sdk.api.ams.operations.artifacts.ArtifactGet;
import net.accelbyte.sdk.api.ams.operations.artifacts.ArtifactGetURL;
import net.accelbyte.sdk.api.ams.operations.artifacts.ArtifactUsageGet;
import net.accelbyte.sdk.api.ams.operations.artifacts.FleetArtifactSamplingRulesGet;
import net.accelbyte.sdk.api.ams.operations.artifacts.FleetArtifactSamplingRulesSet;
import net.accelbyte.sdk.core.HttpResponse;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.RequestRunner;

public class Artifacts {
    private RequestRunner sdk;
    private String customBasePath = "";

    public Artifacts(RequestRunner sdk) {
        this.sdk = sdk;
        String configCustomBasePath = sdk.getSdkConfiguration().getConfigRepository().getCustomServiceBasePath("ams");
        if (!configCustomBasePath.equals("")) {
            this.customBasePath = configCustomBasePath;
        }
    }

    public Artifacts(RequestRunner sdk, String customBasePath) {
        this.sdk = sdk;
        this.customBasePath = customBasePath;
    }

    public ApiArtifactListResponse artifactGet(ArtifactGet input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public void artifactBulkDelete(ArtifactBulkDelete input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        input.handleEmptyResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public ApiArtifactUsageResponse artifactUsageGet(ArtifactUsageGet input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public void artifactDelete(ArtifactDelete input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        input.handleEmptyResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public ApiArtifactURLResponse artifactGetURL(ArtifactGetURL input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public ApiFleetArtifactsSampleRules fleetArtifactSamplingRulesGet(FleetArtifactSamplingRulesGet input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public ApiFleetArtifactsSampleRules fleetArtifactSamplingRulesSet(FleetArtifactSamplingRulesSet input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }
}

