/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ams.wrappers;

import net.accelbyte.sdk.api.ams.models.ApiAMSRegionsResponse;
import net.accelbyte.sdk.api.ams.models.ApiAvailableInstanceTypesResponse;
import net.accelbyte.sdk.api.ams.operations.ams_info.InfoRegions;
import net.accelbyte.sdk.api.ams.operations.ams_info.InfoSupportedInstances;
import net.accelbyte.sdk.api.ams.operations.ams_info.UploadURLGet;
import net.accelbyte.sdk.core.HttpResponse;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.RequestRunner;

public class AMSInfo {
    private RequestRunner sdk;
    private String customBasePath = "";

    public AMSInfo(RequestRunner sdk) {
        this.sdk = sdk;
        String configCustomBasePath = sdk.getSdkConfiguration().getConfigRepository().getCustomServiceBasePath("ams");
        if (!configCustomBasePath.equals("")) {
            this.customBasePath = configCustomBasePath;
        }
    }

    public AMSInfo(RequestRunner sdk, String customBasePath) {
        this.sdk = sdk;
        this.customBasePath = customBasePath;
    }

    public ApiAMSRegionsResponse infoRegions(InfoRegions input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public ApiAvailableInstanceTypesResponse infoSupportedInstances(InfoSupportedInstances input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public void uploadURLGet(UploadURLGet input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        input.handleEmptyResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }
}

