/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ams.operations.watchdogs;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class LocalWatchdogConnect
extends Operation {
    private String path = "/ams/v1/namespaces/{namespace}/local/{watchdogID}/connect";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String watchdogID;

    @Deprecated
    public LocalWatchdogConnect(String customBasePath, String namespace, String watchdogID) {
        this.namespace = namespace;
        this.watchdogID = watchdogID;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.watchdogID != null) {
            pathParams.put("watchdogID", this.watchdogID);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.watchdogID != null;
    }

    public void handleEmptyResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
    }

    public static LocalWatchdogConnectBuilder builder() {
        return new LocalWatchdogConnectBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getWatchdogID() {
        return this.watchdogID;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setWatchdogID(String watchdogID) {
        this.watchdogID = watchdogID;
    }

    public static class LocalWatchdogConnectBuilder {
        private String customBasePath;
        private String namespace;
        private String watchdogID;

        LocalWatchdogConnectBuilder() {
        }

        public LocalWatchdogConnectBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public LocalWatchdogConnectBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public LocalWatchdogConnectBuilder watchdogID(String watchdogID) {
            this.watchdogID = watchdogID;
            return this;
        }

        public LocalWatchdogConnect build() {
            return new LocalWatchdogConnect(this.customBasePath, this.namespace, this.watchdogID);
        }

        public String toString() {
            return "LocalWatchdogConnect.LocalWatchdogConnectBuilder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", watchdogID=" + this.watchdogID + ")";
        }
    }
}

