/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ams.operations.servers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.ams.models.ApiFleetServerInfoResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class FleetServerInfo
extends Operation {
    private String path = "/ams/v1/admin/namespaces/{namespace}/servers/{serverID}";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String serverID;

    @Deprecated
    public FleetServerInfo(String customBasePath, String namespace, String serverID) {
        this.namespace = namespace;
        this.serverID = serverID;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.serverID != null) {
            pathParams.put("serverID", this.serverID);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.serverID != null;
    }

    public ApiFleetServerInfoResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ApiFleetServerInfoResponse().createFromJson(json);
    }

    public static FleetServerInfoBuilder builder() {
        return new FleetServerInfoBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getServerID() {
        return this.serverID;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setServerID(String serverID) {
        this.serverID = serverID;
    }

    public static class FleetServerInfoBuilder {
        private String customBasePath;
        private String namespace;
        private String serverID;

        FleetServerInfoBuilder() {
        }

        public FleetServerInfoBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public FleetServerInfoBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public FleetServerInfoBuilder serverID(String serverID) {
            this.serverID = serverID;
            return this;
        }

        public FleetServerInfo build() {
            return new FleetServerInfo(this.customBasePath, this.namespace, this.serverID);
        }

        public String toString() {
            return "FleetServerInfo.FleetServerInfoBuilder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", serverID=" + this.serverID + ")";
        }
    }
}

