/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ams.operations.servers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.ams.models.ApiDSHistoryList;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class FleetServerHistory
extends Operation {
    private String path = "/ams/v1/admin/namespaces/{namespace}/fleets/{fleetID}/servers/history";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String fleetID;
    private String namespace;
    private Integer count;
    private Integer offset;
    private String reason;
    private String region;
    private String serverId;
    private String sortDirection;
    private String status;

    @Deprecated
    public FleetServerHistory(String customBasePath, String fleetID, String namespace, Integer count, Integer offset, String reason, String region, String serverId, String sortDirection, String status) {
        this.fleetID = fleetID;
        this.namespace = namespace;
        this.count = count;
        this.offset = offset;
        this.reason = reason;
        this.region = region;
        this.serverId = serverId;
        this.sortDirection = sortDirection;
        this.status = status;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.fleetID != null) {
            pathParams.put("fleetID", this.fleetID);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("count", this.count == null ? null : Arrays.asList(String.valueOf(this.count)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("reason", this.reason == null ? null : Arrays.asList(this.reason));
        queryParams.put("region", this.region == null ? null : Arrays.asList(this.region));
        queryParams.put("serverId", this.serverId == null ? null : Arrays.asList(this.serverId));
        queryParams.put("sortDirection", this.sortDirection == null ? null : Arrays.asList(this.sortDirection));
        queryParams.put("status", this.status == null ? null : Arrays.asList(this.status));
        return queryParams;
    }

    public boolean isValid() {
        if (this.fleetID == null) {
            return false;
        }
        return this.namespace != null;
    }

    public ApiDSHistoryList parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ApiDSHistoryList().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("count", "None");
        result.put("offset", "None");
        result.put("reason", "None");
        result.put("region", "None");
        result.put("serverId", "None");
        result.put("sortDirection", "None");
        result.put("status", "None");
        return result;
    }

    public static FleetServerHistoryBuilder builder() {
        return new FleetServerHistoryBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getFleetID() {
        return this.fleetID;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Integer getCount() {
        return this.count;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getReason() {
        return this.reason;
    }

    public String getRegion() {
        return this.region;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getSortDirection() {
        return this.sortDirection;
    }

    public String getStatus() {
        return this.status;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setFleetID(String fleetID) {
        this.fleetID = fleetID;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public void setSortDirection(String sortDirection) {
        this.sortDirection = sortDirection;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public static class FleetServerHistoryBuilder {
        private String customBasePath;
        private String fleetID;
        private String namespace;
        private Integer count;
        private Integer offset;
        private String reason;
        private String region;
        private String serverId;
        private String sortDirection;
        private String status;

        FleetServerHistoryBuilder() {
        }

        public FleetServerHistoryBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public FleetServerHistoryBuilder fleetID(String fleetID) {
            this.fleetID = fleetID;
            return this;
        }

        public FleetServerHistoryBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public FleetServerHistoryBuilder count(Integer count) {
            this.count = count;
            return this;
        }

        public FleetServerHistoryBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public FleetServerHistoryBuilder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public FleetServerHistoryBuilder region(String region) {
            this.region = region;
            return this;
        }

        public FleetServerHistoryBuilder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public FleetServerHistoryBuilder sortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
            return this;
        }

        public FleetServerHistoryBuilder status(String status) {
            this.status = status;
            return this;
        }

        public FleetServerHistory build() {
            return new FleetServerHistory(this.customBasePath, this.fleetID, this.namespace, this.count, this.offset, this.reason, this.region, this.serverId, this.sortDirection, this.status);
        }

        public String toString() {
            return "FleetServerHistory.FleetServerHistoryBuilder(customBasePath=" + this.customBasePath + ", fleetID=" + this.fleetID + ", namespace=" + this.namespace + ", count=" + this.count + ", offset=" + this.offset + ", reason=" + this.reason + ", region=" + this.region + ", serverId=" + this.serverId + ", sortDirection=" + this.sortDirection + ", status=" + this.status + ")";
        }
    }
}

