/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ams.operations.images;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.ams.models.ApiImageDetails;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class ImageGet
extends Operation {
    private String path = "/ams/v1/admin/namespaces/{namespace}/images/{imageID}";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String imageID;
    private String namespace;

    @Deprecated
    public ImageGet(String customBasePath, String imageID, String namespace) {
        this.imageID = imageID;
        this.namespace = namespace;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.imageID != null) {
            pathParams.put("imageID", this.imageID);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.imageID == null) {
            return false;
        }
        return this.namespace != null;
    }

    public ApiImageDetails parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ApiImageDetails().createFromJson(json);
    }

    public static ImageGetBuilder builder() {
        return new ImageGetBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getImageID() {
        return this.imageID;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setImageID(String imageID) {
        this.imageID = imageID;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public static class ImageGetBuilder {
        private String customBasePath;
        private String imageID;
        private String namespace;

        ImageGetBuilder() {
        }

        public ImageGetBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public ImageGetBuilder imageID(String imageID) {
            this.imageID = imageID;
            return this;
        }

        public ImageGetBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ImageGet build() {
            return new ImageGet(this.customBasePath, this.imageID, this.namespace);
        }

        public String toString() {
            return "ImageGet.ImageGetBuilder(customBasePath=" + this.customBasePath + ", imageID=" + this.imageID + ", namespace=" + this.namespace + ")";
        }
    }
}

