/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ams.operations.fleets;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.ams.models.ApiFleetParameters;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class FleetUpdate
extends Operation {
    private String path = "/ams/v1/admin/namespaces/{namespace}/fleets/{fleetID}";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String fleetID;
    private String namespace;
    private ApiFleetParameters body;

    @Deprecated
    public FleetUpdate(String customBasePath, String fleetID, String namespace, ApiFleetParameters body) {
        this.fleetID = fleetID;
        this.namespace = namespace;
        this.body = body;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.fleetID != null) {
            pathParams.put("fleetID", this.fleetID);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public ApiFleetParameters getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.fleetID == null) {
            return false;
        }
        return this.namespace != null;
    }

    public void handleEmptyResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 204) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
    }

    public static FleetUpdateBuilder builder() {
        return new FleetUpdateBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getFleetID() {
        return this.fleetID;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ApiFleetParameters getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setFleetID(String fleetID) {
        this.fleetID = fleetID;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBody(ApiFleetParameters body) {
        this.body = body;
    }

    public static class FleetUpdateBuilder {
        private String customBasePath;
        private String fleetID;
        private String namespace;
        private ApiFleetParameters body;

        FleetUpdateBuilder() {
        }

        public FleetUpdateBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public FleetUpdateBuilder fleetID(String fleetID) {
            this.fleetID = fleetID;
            return this;
        }

        public FleetUpdateBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public FleetUpdateBuilder body(ApiFleetParameters body) {
            this.body = body;
            return this;
        }

        public FleetUpdate build() {
            return new FleetUpdate(this.customBasePath, this.fleetID, this.namespace, this.body);
        }

        public String toString() {
            return "FleetUpdate.FleetUpdateBuilder(customBasePath=" + this.customBasePath + ", fleetID=" + this.fleetID + ", namespace=" + this.namespace + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

