/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ams.operations.fleets;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.ams.models.ApiFleetClaimReq;
import net.accelbyte.sdk.api.ams.models.ApiFleetClaimResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class FleetClaimByID
extends Operation {
    private String path = "/ams/v1/namespaces/{namespace}/fleets/{fleetID}/claim";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String fleetID;
    private String namespace;
    private ApiFleetClaimReq body;

    @Deprecated
    public FleetClaimByID(String customBasePath, String fleetID, String namespace, ApiFleetClaimReq body) {
        this.fleetID = fleetID;
        this.namespace = namespace;
        this.body = body;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.fleetID != null) {
            pathParams.put("fleetID", this.fleetID);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public ApiFleetClaimReq getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.fleetID == null) {
            return false;
        }
        return this.namespace != null;
    }

    public ApiFleetClaimResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ApiFleetClaimResponse().createFromJson(json);
    }

    public static FleetClaimByIDBuilder builder() {
        return new FleetClaimByIDBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getFleetID() {
        return this.fleetID;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ApiFleetClaimReq getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setFleetID(String fleetID) {
        this.fleetID = fleetID;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBody(ApiFleetClaimReq body) {
        this.body = body;
    }

    public static class FleetClaimByIDBuilder {
        private String customBasePath;
        private String fleetID;
        private String namespace;
        private ApiFleetClaimReq body;

        FleetClaimByIDBuilder() {
        }

        public FleetClaimByIDBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public FleetClaimByIDBuilder fleetID(String fleetID) {
            this.fleetID = fleetID;
            return this;
        }

        public FleetClaimByIDBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public FleetClaimByIDBuilder body(ApiFleetClaimReq body) {
            this.body = body;
            return this;
        }

        public FleetClaimByID build() {
            return new FleetClaimByID(this.customBasePath, this.fleetID, this.namespace, this.body);
        }

        public String toString() {
            return "FleetClaimByID.FleetClaimByIDBuilder(customBasePath=" + this.customBasePath + ", fleetID=" + this.fleetID + ", namespace=" + this.namespace + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

