/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ams.operations.artifacts;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.ams.models.ApiArtifactListResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class ArtifactGet
extends Operation {
    private String path = "/ams/v1/admin/namespaces/{namespace}/artifacts";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String artifactType;
    private Integer count;
    private String endDate;
    private String fleetID;
    private String imageID;
    private Integer maxSize;
    private Integer minSize;
    private Integer offset;
    private String region;
    private String serverId;
    private String startDate;
    private String status;

    @Deprecated
    public ArtifactGet(String customBasePath, String namespace, String artifactType, Integer count, String endDate, String fleetID, String imageID, Integer maxSize, Integer minSize, Integer offset, String region, String serverId, String startDate, String status) {
        this.namespace = namespace;
        this.artifactType = artifactType;
        this.count = count;
        this.endDate = endDate;
        this.fleetID = fleetID;
        this.imageID = imageID;
        this.maxSize = maxSize;
        this.minSize = minSize;
        this.offset = offset;
        this.region = region;
        this.serverId = serverId;
        this.startDate = startDate;
        this.status = status;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("artifactType", this.artifactType == null ? null : Arrays.asList(this.artifactType));
        queryParams.put("count", this.count == null ? null : Arrays.asList(String.valueOf(this.count)));
        queryParams.put("endDate", this.endDate == null ? null : Arrays.asList(this.endDate));
        queryParams.put("fleetID", this.fleetID == null ? null : Arrays.asList(this.fleetID));
        queryParams.put("imageID", this.imageID == null ? null : Arrays.asList(this.imageID));
        queryParams.put("maxSize", this.maxSize == null ? null : Arrays.asList(String.valueOf(this.maxSize)));
        queryParams.put("minSize", this.minSize == null ? null : Arrays.asList(String.valueOf(this.minSize)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("region", this.region == null ? null : Arrays.asList(this.region));
        queryParams.put("serverId", this.serverId == null ? null : Arrays.asList(this.serverId));
        queryParams.put("startDate", this.startDate == null ? null : Arrays.asList(this.startDate));
        queryParams.put("status", this.status == null ? null : Arrays.asList(this.status));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public ApiArtifactListResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ApiArtifactListResponse().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("artifactType", "None");
        result.put("count", "None");
        result.put("endDate", "None");
        result.put("fleetID", "None");
        result.put("imageID", "None");
        result.put("maxSize", "None");
        result.put("minSize", "None");
        result.put("offset", "None");
        result.put("region", "None");
        result.put("serverId", "None");
        result.put("startDate", "None");
        result.put("status", "None");
        return result;
    }

    public static ArtifactGetBuilder builder() {
        return new ArtifactGetBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getArtifactType() {
        return this.artifactType;
    }

    public Integer getCount() {
        return this.count;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public String getFleetID() {
        return this.fleetID;
    }

    public String getImageID() {
        return this.imageID;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public Integer getMinSize() {
        return this.minSize;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getRegion() {
        return this.region;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getStatus() {
        return this.status;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setArtifactType(String artifactType) {
        this.artifactType = artifactType;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void setFleetID(String fleetID) {
        this.fleetID = fleetID;
    }

    public void setImageID(String imageID) {
        this.imageID = imageID;
    }

    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    public void setMinSize(Integer minSize) {
        this.minSize = minSize;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public static class ArtifactGetBuilder {
        private String customBasePath;
        private String namespace;
        private String artifactType;
        private Integer count;
        private String endDate;
        private String fleetID;
        private String imageID;
        private Integer maxSize;
        private Integer minSize;
        private Integer offset;
        private String region;
        private String serverId;
        private String startDate;
        private String status;

        ArtifactGetBuilder() {
        }

        public ArtifactGetBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public ArtifactGetBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ArtifactGetBuilder artifactType(String artifactType) {
            this.artifactType = artifactType;
            return this;
        }

        public ArtifactGetBuilder count(Integer count) {
            this.count = count;
            return this;
        }

        public ArtifactGetBuilder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public ArtifactGetBuilder fleetID(String fleetID) {
            this.fleetID = fleetID;
            return this;
        }

        public ArtifactGetBuilder imageID(String imageID) {
            this.imageID = imageID;
            return this;
        }

        public ArtifactGetBuilder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public ArtifactGetBuilder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public ArtifactGetBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public ArtifactGetBuilder region(String region) {
            this.region = region;
            return this;
        }

        public ArtifactGetBuilder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public ArtifactGetBuilder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public ArtifactGetBuilder status(String status) {
            this.status = status;
            return this;
        }

        public ArtifactGet build() {
            return new ArtifactGet(this.customBasePath, this.namespace, this.artifactType, this.count, this.endDate, this.fleetID, this.imageID, this.maxSize, this.minSize, this.offset, this.region, this.serverId, this.startDate, this.status);
        }

        public String toString() {
            return "ArtifactGet.ArtifactGetBuilder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", artifactType=" + this.artifactType + ", count=" + this.count + ", endDate=" + this.endDate + ", fleetID=" + this.fleetID + ", imageID=" + this.imageID + ", maxSize=" + this.maxSize + ", minSize=" + this.minSize + ", offset=" + this.offset + ", region=" + this.region + ", serverId=" + this.serverId + ", startDate=" + this.startDate + ", status=" + this.status + ")";
        }
    }
}

