/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ams.operations.ams_qo_s;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.ams.models.ApiQoSEndpointResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class QoSRegionsGet
extends Operation {
    private String path = "/ams/v1/admin/namespaces/{namespace}/qos";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String status;

    @Deprecated
    public QoSRegionsGet(String customBasePath, String namespace, String status) {
        this.namespace = namespace;
        this.status = status;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("status", this.status == null ? null : Arrays.asList(this.status));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public ApiQoSEndpointResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ApiQoSEndpointResponse().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("status", "None");
        return result;
    }

    public static QoSRegionsGetBuilder builder() {
        return new QoSRegionsGetBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getStatus() {
        return this.status;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public static class QoSRegionsGetBuilder {
        private String customBasePath;
        private String namespace;
        private String status;

        QoSRegionsGetBuilder() {
        }

        public QoSRegionsGetBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public QoSRegionsGetBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public QoSRegionsGetBuilder status(String status) {
            this.status = status;
            return this;
        }

        public QoSRegionsGet build() {
            return new QoSRegionsGet(this.customBasePath, this.namespace, this.status);
        }

        public String toString() {
            return "QoSRegionsGet.QoSRegionsGetBuilder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", status=" + this.status + ")";
        }
    }
}

