/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.context;

import java.util.concurrent.atomic.AtomicReference;
import net.abstractfactory.common.Context;
import net.abstractfactory.plum.view.component.containers.window.ViewRefreshTask;
import net.abstractfactory.plum.view.component.containers.window.WindowManager;
import org.apache.log4j.Logger;

public class ViewSessionContextUtils {
    static Logger logger = Logger.getLogger(ViewSessionContextUtils.class);
    private static final String WINDOW_MANAGER = "windowManager";
    private static final String VIEW_REFRESH_TASK = "viewRefreshTask";

    public static WindowManager getWindowManager(Context sessionContext) {
        return (WindowManager)sessionContext.get(WINDOW_MANAGER);
    }

    public static void setWindowManager(Context sessionContext, WindowManager windowManager) {
        sessionContext.set(WINDOW_MANAGER, (Object)windowManager);
    }

    private static AtomicReference<ViewRefreshTask> getViewRefreshTaskRef(Context sessionContext) {
        return (AtomicReference)sessionContext.get(VIEW_REFRESH_TASK);
    }

    private static void setViewRefreshTaskRef(Context sessionContext, AtomicReference<ViewRefreshTask> viewRefreshTask) {
        sessionContext.set(VIEW_REFRESH_TASK, viewRefreshTask);
    }

    public static void init(Context sessionContext) {
        AtomicReference<ViewRefreshTask> ref = new AtomicReference<ViewRefreshTask>();
        ViewSessionContextUtils.setViewRefreshTaskRef(sessionContext, ref);
    }

    public static void setRefreshViewTask(Context sessionContext, ViewRefreshTask task) {
        AtomicReference<ViewRefreshTask> ref = ViewSessionContextUtils.getViewRefreshTaskRef(sessionContext);
        logger.debug((Object)"VewRefreshTask is set.");
        boolean success = ref.compareAndSet(null, task);
        if (!success) {
            throw new RuntimeException("refresh view task is already set");
        }
    }

    public static ViewRefreshTask takeRefreshViewFutureTask(Context sessionContext) {
        logger.debug((Object)"VewRefreshTask is taken.");
        AtomicReference<ViewRefreshTask> ref = ViewSessionContextUtils.getViewRefreshTaskRef(sessionContext);
        return ref.getAndSet(null);
    }
}

