/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.component.menu;

import net.abstractfactory.plum.model.ViewAction;
import net.abstractfactory.plum.view.Visitor;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.menu.MenuBar;
import net.abstractfactory.plum.view.event.EventListener;

public class MenuItem
extends Component {
    public static final String EVENT_CLICK = "click";

    public void addClickListener(EventListener listener) {
        this.addEventListener(EVENT_CLICK, listener);
    }

    public void click() {
        this.notifyEventListeners(EVENT_CLICK, null);
    }

    @Override
    public Object accept(Visitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public void updateView() {
        super.updateView();
        ViewAction model = (ViewAction)this.getModel();
        if (model != null) {
            this.setName(model.getName());
            this.setCaption(model.getCaption());
            this.clearEventListener();
            this.addClickListener(model.getActionListener());
        }
    }

    public int getMenuDepth() {
        int i;
        block1: {
            i = 0;
            MenuItem node = this;
            do {
                node = node.getParent();
                ++i;
                if (node instanceof MenuBar) break block1;
            } while (i != 10);
            throw new RuntimeException("menu depth should less than 10.");
        }
        return i;
    }
}

