/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.component.listbox;

import net.abstractfactory.plum.view.Visitor;
import net.abstractfactory.plum.view._abstract.components.listbox.option.Options;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.listbox.SingleSelector;

public class DropdownList
extends Component
implements SingleSelector {
    private Options options;
    private int selectedIndex = -1;

    @Override
    public Object accept(Visitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public void setOptions(Options objects) {
        this.options = objects;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    public void setSelectedIndex(int index) {
        Object old = this.getSelectedValue();
        this.selectedIndex = index;
        Object newVal = this.getSelectedValue();
        this.notifyEventListeners("stateChange");
        this.notifyEventListeners("valueChange", old, newVal);
    }

    @Override
    public Object getSelectedValue() {
        if (this.selectedIndex < 0 || this.selectedIndex >= this.options.size()) {
            return null;
        }
        return this.options.get(this.selectedIndex);
    }

    @Override
    public void setSelectedValue(Object value) {
        Object old = this.getSelectedValue();
        int index = this.options.indexOf(value);
        if (index >= 0) {
            this.setSelectedIndex(index);
            this.notifyEventListeners("stateChange");
            this.notifyEventListeners("valueChange", old, value);
        }
    }
}

