/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.component.containers.window;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.abstractfactory.plum.view.component.containers.window.MainWindow;
import net.abstractfactory.plum.view.component.containers.window.Screen;
import net.abstractfactory.plum.view.component.containers.window.Window;
import org.apache.log4j.Logger;

public class WindowManager {
    private Logger logger = Logger.getLogger(this.getClass());
    private Screen screen = new Screen();
    protected LinkedList<Window> zOrderedWindows = new LinkedList();

    public void register(Window window) {
        this.logger.debug((Object)("window registered:" + window.title));
        this.zOrderedWindows.addLast(window);
        this.screen.addChild(window);
        this.print();
    }

    public MainWindow getMainWindow() {
        return (MainWindow)this.zOrderedWindows.getFirst();
    }

    public List<Window> getAllWindows() {
        return this.zOrderedWindows;
    }

    public int getZIndex(Window window) {
        return this.zOrderedWindows.indexOf((Object)window);
    }

    public void unregister(Window window) {
        this.logger.debug((Object)("window unregistered:" + window.title));
        this.zOrderedWindows.remove((Object)window);
        this.screen.removeChild(window);
    }

    public void bringFront(Window window) {
        this.zOrderedWindows.remove((Object)window);
        this.zOrderedWindows.addLast(window);
    }

    private Window getFontWindow() {
        return this.zOrderedWindows.getLast();
    }

    public Window getVisibleFontWindow() {
        Iterator it = this.zOrderedWindows.iterator();
        Window window = null;
        Window lastVisibleWindow = null;
        while (it.hasNext()) {
            window = (Window)((Object)it.next());
            if (!window.isVisible()) continue;
            lastVisibleWindow = window;
        }
        if (lastVisibleWindow == null) {
            throw new RuntimeException("getVisibleFontWindow(), can not find a visible window");
        }
        return lastVisibleWindow;
    }

    public Screen getScreen() {
        return this.screen;
    }

    public void print() {
        this.logger.debug((Object)("WindowManager Info, size=" + this.zOrderedWindows.size()));
        Iterator it = this.zOrderedWindows.iterator();
        int i = 0;
        while (it.hasNext()) {
            Window w = (Window)((Object)it.next());
            this.logger.debug((Object)String.format("window[%d] name=%s, title=%s ", i, w.getName(), w.getTitle()));
            ++i;
        }
    }
}

