/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.component.containers.window;

import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingDeque;
import net.abstractfactory.common.ApplicationContextUtils;
import net.abstractfactory.common.Context;
import net.abstractfactory.plum.repository.biz.TransactionExecutor;
import net.abstractfactory.plum.view.component.containers.window.EventThreadContext;
import net.abstractfactory.plum.view.component.containers.window.ViewRefreshTask;
import net.abstractfactory.plum.view.component.containers.window.Window;
import net.abstractfactory.plum.view.context.ViewSessionContextUtils;
import net.abstractfactory.plum.view.event.ComponentEvent;
import net.abstractfactory.plum.view.event.Event;
import net.abstractfactory.plum.view.event.StopThreadEvent;
import net.abstractfactory.plum.view.event.TimeToRefreshViewEvent;
import org.apache.log4j.Logger;

public class WindowEventThread
extends Thread {
    private final Logger logger = Logger.getLogger(WindowEventThread.class);
    private Window window;
    private EventThreadContext context;
    private BlockingDeque<Event> queue = new LinkedBlockingDeque<Event>();
    private WindowEventThread previousEventThread;

    public WindowEventThread(Window window, WindowEventThread previousEventThread) {
        this.window = window;
        this.previousEventThread = previousEventThread;
        EventThreadContext parentContext = null;
        if (previousEventThread != null) {
            parentContext = previousEventThread.getContext();
        }
        this.context = new EventThreadContext((Context)parentContext);
        this.setName("EventThread for '" + window.getTitle() + "'");
    }

    @Override
    public void run() {
        while (true) {
            try {
                Event event = this.queue.take();
                if (event instanceof ComponentEvent) {
                    TransactionExecutor transactionExecutor;
                    final ComponentEvent e = (ComponentEvent)event;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)String.format("start execute event action [%s] %s.%s", ((Object)((Object)e.getComponent())).getClass().getSimpleName(), e.getComponent().getName(), e.getAction().getName()));
                    }
                    if ((transactionExecutor = ApplicationContextUtils.getTransactionExecutor()) == null) {
                        transactionExecutor = new TransactionExecutor();
                    }
                    transactionExecutor.execute((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            try {
                                e.execute();
                            }
                            catch (Throwable e2) {
                                e2.printStackTrace();
                                WindowEventThread.this.logger.error((Object)e2);
                            }
                            return null;
                        }
                    });
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)String.format("end execute event action [%s] %s.%s", ((Object)((Object)e.getComponent())).getClass().getSimpleName(), e.getComponent().getName(), e.getAction().getName()));
                    continue;
                }
                if (event instanceof TimeToRefreshViewEvent) {
                    if (this.window.isVisible()) {
                        Context sessionContext = EventThreadContext.getCurrentThreadContext().getSessionContext();
                        ViewRefreshTask refreshViewFutureTask = ViewSessionContextUtils.takeRefreshViewFutureTask(sessionContext);
                        if (refreshViewFutureTask != null) {
                            this.logger.debug((Object)String.format("%s thread execute refresh view task.", this.window.getTitle()));
                            refreshViewFutureTask.run();
                            continue;
                        }
                        this.logger.debug((Object)"skip refresh view because there is no ViewRefreshTask in session.");
                        continue;
                    }
                    this.logger.debug((Object)"skip refresh view because current window is not visible.");
                    continue;
                }
                if (!(event instanceof StopThreadEvent)) continue;
                this.logger.info((Object)("stop thread: " + this.getName()));
            }
            catch (InterruptedException e) {
                this.logger.debug((Object)"window thread exiting...");
            }
            catch (Exception e) {
                this.logger.error((Object)e);
                continue;
            }
            break;
        }
    }

    public synchronized void addEvent(Event e) {
        this.queue.add(e);
    }

    public synchronized void addEvents(List<Event> events) {
        this.queue.addAll(events);
    }

    public synchronized void stopThread() {
        this.queue.add(new StopThreadEvent());
    }

    public Window getWindow() {
        return this.window;
    }

    public EventThreadContext getContext() {
        return this.context;
    }

    public WindowEventThread getPreviousEventThread() {
        return this.previousEventThread;
    }
}

