/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.component.containers.window;

import java.util.ArrayList;
import java.util.List;
import net.abstractfactory.plum.view.Visitor;
import net.abstractfactory.plum.view.component.Button;
import net.abstractfactory.plum.view.component.ClickEventListener;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.Label;
import net.abstractfactory.plum.view.component.containers.Panel;
import net.abstractfactory.plum.view.component.containers.window.Dialog;
import net.abstractfactory.plum.view.component.containers.window.WindowEventThread;
import net.abstractfactory.plum.view.component.containers.window.WindowManager;
import org.apache.log4j.Logger;

public class Window
extends Component {
    private static Logger logger = Logger.getLogger(Window.class);
    public static final String NAME_TITLE_PANEL = "titlePanel";
    public static final String NAME_TITLE_LABEL = "titleLabel";
    public static final String NAME_CLOSE_BUTTON = "closeButton";
    public static final String NAME_CONTENT_PANEL = "contentPanel";
    protected Window parentWindow;
    protected List<Window> childWindows;
    protected String title;
    protected Label titleLabel;
    protected Button closeButton;
    protected Panel titlePanel;
    protected Panel contentPanel;
    protected WindowManager windowManager;
    protected WindowEventThread eventThread;

    public Window() {
        this.visible = false;
        this.childWindows = new ArrayList<Window>();
        this.init();
    }

    private void init() {
        this.titlePanel = new Panel();
        this.titlePanel.setName(NAME_TITLE_PANEL);
        this.titleLabel = new Label();
        this.titleLabel.setName(NAME_TITLE_LABEL);
        this.titleLabel.setText(this.title);
        this.titlePanel.addChild(this.titleLabel);
        this.closeButton = new Button();
        this.closeButton.setName(NAME_CLOSE_BUTTON);
        this.closeButton.setCaption("X");
        this.closeButton.addClickListener(new ClickEventListener(){

            @Override
            public void onClick(Component source) {
                Window.this.closeWindow();
            }
        });
        this.titlePanel.addChild(this.closeButton);
        this.contentPanel = new Panel();
        this.contentPanel.setName(NAME_CONTENT_PANEL);
        this.addChild(this.titlePanel);
        this.addChild(this.contentPanel);
    }

    public void closeWindow() {
        this.hide();
        this.getEventThread().stopThread();
        Window parentWindow = this.getParentWindow();
        if (parentWindow != null) {
            parentWindow.removeChildWindow(this);
        }
        this.destroy();
    }

    public Window getParentWindow() {
        return this.parentWindow;
    }

    public void setParentWindow(Window parentWindow) {
        if (this.parentWindow != null) {
            this.parentWindow.removeChildWindow(this);
        }
        this.parentWindow = parentWindow;
        if (parentWindow != null) {
            parentWindow.addChildWindow(this);
        }
    }

    public void addChildWindow(Window child) {
        Dialog dlg;
        child.parentWindow = this;
        this.childWindows.add(child);
        this.windowManager.register(child);
        child.setWindowManager(this.windowManager);
        if (child.getEventThread() == null) {
            child.setEventThread(this.eventThread);
        }
        if (child instanceof Dialog && (dlg = (Dialog)child).isModal()) {
            this.windowManager.bringFront(dlg);
        }
    }

    public void removeChildWindow(Window child) {
        child.parentWindow = null;
        this.childWindows.remove((Object)child);
        this.windowManager.unregister(child);
        logger.debug((Object)("now font window is " + this.windowManager.getVisibleFontWindow().title));
    }

    public List<Window> getChildWindows() {
        return this.childWindows;
    }

    public Window getRootWindow() {
        if (this.parentWindow == null) {
            return this;
        }
        return this.parentWindow.getRootWindow();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.titleLabel.setText(title);
        if (this.eventThread != null) {
            this.eventThread.setName("EventThread for '" + this.getTitle() + "'");
        }
    }

    public Panel getTitlePanel() {
        return this.titlePanel;
    }

    public Panel getContentPanel() {
        return this.contentPanel;
    }

    public void setContentPanel(Panel contentPanel) {
        this.contentPanel = contentPanel;
        this.removeAllChildren();
        this.addChild(contentPanel);
    }

    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    public void setWindowManager(WindowManager windowManager) {
        this.windowManager = windowManager;
    }

    public void setEventThread(WindowEventThread eventThread) {
        this.eventThread = eventThread;
    }

    public WindowEventThread getEventThread() {
        return this.eventThread;
    }

    @Override
    public Object accept(Visitor visitor) {
        return visitor.visit(this);
    }
}

