/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.component.containers.window;

import java.util.concurrent.Semaphore;
import net.abstractfactory.common.Context;
import net.abstractfactory.plum.view.Visitor;
import net.abstractfactory.plum.view.component.containers.window.EventThreadContext;
import net.abstractfactory.plum.view.component.containers.window.ModalResult;
import net.abstractfactory.plum.view.component.containers.window.ViewRefreshTask;
import net.abstractfactory.plum.view.component.containers.window.Window;
import net.abstractfactory.plum.view.component.containers.window.WindowEventThread;
import net.abstractfactory.plum.view.context.ViewSessionContextUtils;

public class Dialog
extends Window {
    private Semaphore active = new Semaphore(0);
    protected boolean modal;
    protected ModalResult modalResult = ModalResult.CANCEL;

    public Dialog() {
        WindowEventThread thread = (WindowEventThread)Thread.currentThread();
        this.eventThread = new WindowEventThread(this, thread);
        this.eventThread.start();
    }

    public boolean isModal() {
        return this.modal;
    }

    public void setModal(boolean modal) {
        this.modal = modal;
    }

    public ModalResult getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(ModalResult modalResult) {
        this.modalResult = modalResult;
    }

    public void closeDialog(ModalResult modalResult) {
        this.setModalResult(modalResult);
        this.closeWindow();
    }

    protected void closeDialog() {
        this.active.release();
    }

    @Override
    public void closeWindow() {
        super.closeWindow();
        this.closeDialog();
    }

    public ModalResult showModal(Window parent) {
        parent.addChildWindow(this);
        this.getWindowManager().bringFront(this);
        this.show();
        Context sessionContext = EventThreadContext.getCurrentThreadContext().getSessionContext();
        ViewRefreshTask refreshViewTask = ViewSessionContextUtils.takeRefreshViewFutureTask(sessionContext);
        if (refreshViewTask != null) {
            refreshViewTask.run();
        }
        try {
            this.active.acquire();
            return this.modalResult;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object accept(Visitor visitor) {
        return visitor.visit(this);
    }
}

