/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.component;

import java.util.List;
import net.abstractfactory.plum.view.Visitor;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.Label;
import net.abstractfactory.plum.view.component.containers.layout.HorizontalBox;
import net.abstractfactory.plum.view.component.containers.layout.VerticalBox;

public class ListView
extends VerticalBox {
    private List<Component> items;

    void recreateUI() {
        this.removeAllChildren();
        Label label = new Label();
        this.addChild(label);
        for (Component item : this.items) {
            HorizontalBox row = new HorizontalBox();
            row.addChild(item);
            this.addChild(row);
        }
    }

    public void setItems(List items) {
        this.items = items;
        this.recreateUI();
    }

    public void setItems(List items, boolean notify) {
        List<Component> oldItems = this.items;
        List newItems = items;
        this.items = items;
        this.recreateUI();
        if (notify) {
            this.notifyEventListeners("stateChange");
            this.notifyEventListeners("valueChange", oldItems, newItems);
        }
    }

    @Override
    public Object accept(Visitor visitor) {
        return visitor.visit(this);
    }
}

