/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.component;

import java.util.HashSet;
import java.util.Set;
import net.abstractfactory.plum.view.Visitor;
import net.abstractfactory.plum.view._abstract.components.listbox.option.Options;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.listbox.MultipleSelector;
import net.abstractfactory.plum.view.component.listbox.SelectionMode;
import net.abstractfactory.plum.view.component.listbox.SingleSelector;

public class ListBox
extends Component
implements SingleSelector,
MultipleSelector<Object> {
    protected Options options;
    private int selectedIndex = -1;
    protected Set<Integer> selectedIndices = new HashSet<Integer>();
    protected SelectionMode selectionMode;

    @Override
    public void setOptions(Options options) {
        this.options = options;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    public void setSelectedIndex(int index) {
        Object old = this.getSelectedValue();
        this.selectedIndex = index;
        Object newVal = this.getSelectedValue();
        this.notifyEventListeners("stateChange");
        this.notifyEventListeners("valueChange", old, newVal);
    }

    @Override
    public Object getSelectedValue() {
        if (this.selectedIndex < 0 || this.selectedIndex >= this.options.size()) {
            return null;
        }
        return this.options.get(this.selectedIndex);
    }

    @Override
    public void setSelectedValue(Object value) {
        Object old = this.getSelectedValue();
        int index = this.options.indexOf(value);
        if (index >= 0) {
            this.setSelectedIndex(index);
            this.notifyEventListeners("stateChange");
            this.notifyEventListeners("valueChange", old, value);
        }
    }

    @Override
    public Set<Integer> getSelectedIndices() {
        return this.selectedIndices;
    }

    @Override
    public void setSelectedIndices(Set<Integer> indices) {
        this.selectedIndices.clear();
        this.selectedIndices.addAll(indices);
    }

    public void setSelectedIndices(Set<Integer> indices, boolean notify) {
        Set<Object> oldValue = this.getSelectedValues();
        this.selectedIndices.clear();
        this.selectedIndices.addAll(indices);
        Set<Object> newValue = this.getSelectedValues();
        if (notify) {
            this.notifyEventListeners("stateChange");
            this.notifyEventListeners("valueChange", oldValue, newValue);
        }
    }

    @Override
    public Set<Object> getSelectedValues() {
        HashSet<Object> values = new HashSet<Object>();
        for (int i : this.selectedIndices) {
            values.add(this.options.get(i));
        }
        return values;
    }

    @Override
    public void setSelectedValues(Set<Object> values) {
        this.selectedIndices.clear();
        for (Object value : values) {
            Integer index = this.options.indexOf(value);
            this.selectedIndices.add(index);
        }
    }

    public void setSelectedValues(Set<Object> values, boolean notify) {
        Set<Object> oldValue = this.getSelectedValues();
        Set<Object> newValue = values;
        this.setSelectedValues(values);
        if (notify) {
            this.notifyEventListeners("stateChange");
            this.notifyEventListeners("valueChange", oldValue, newValue);
        }
    }

    public SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(SelectionMode selectionMode) {
        this.selectionMode = selectionMode;
    }

    @Override
    public String toString() {
        if (this.options.size() == 0) {
            return super.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < this.options.size(); ++i) {
            Object option = this.options.get(i);
            sb.append(option);
            sb.append("|");
        }
        sb.replace(sb.length() - 1, sb.length(), ")");
        return super.toString() + sb.toString();
    }

    @Override
    public Object accept(Visitor visitor) {
        return visitor.visit(this);
    }
}

