/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.component;

import java.text.SimpleDateFormat;
import java.util.Date;
import net.abstractfactory.common.CompareUtils;
import net.abstractfactory.plum.view.Visitor;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.DateTimePickerMode;

public class DateTimePicker
extends Component {
    private Date datetime;
    private String format = "yyyy/MM/dd hh:mm:ss";
    private DateTimePickerMode mode = DateTimePickerMode.BOTH;

    public Date getDatetime() {
        return this.datetime;
    }

    public void setDatetime(Date datetime) {
        this.datetime = datetime;
    }

    public void setDatetime(Date datetime, boolean notify) {
        Date oldValue = this.datetime;
        Date newValue = datetime;
        this.datetime = datetime;
        if (notify && !CompareUtils.equals((Object)oldValue, (Object)newValue)) {
            this.notifyEventListeners("stateChange");
            this.notifyEventListeners("valueChange", oldValue, newValue);
        }
    }

    public String getDateTimeString() {
        if (this.datetime != null) {
            return new SimpleDateFormat(this.format).format(this.datetime);
        }
        return null;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public DateTimePickerMode getMode() {
        return this.mode;
    }

    public void setMode(DateTimePickerMode mode) {
        this.mode = mode;
    }

    @Override
    public Object accept(Visitor visitor) {
        return visitor.visit(this);
    }
}

