/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.abstractfactory.common.TreeNode;
import net.abstractfactory.plum.view.Visitor;
import net.abstractfactory.plum.view.component.containers.window.Window;
import net.abstractfactory.plum.view.component.window.PackingCase;
import net.abstractfactory.plum.view.event.EventListener;
import net.abstractfactory.plum.view.misc.Color;
import net.abstractfactory.plum.view.misc.Font;

public abstract class Component
extends TreeNode {
    public static final String EVENT_BEFORE_REFRESH_VIEW = "beforeRefresh";
    public static final String EVENT_BEFORE_UPDATE_VIEW = "beforeUpdateView";
    public static final String EVENT_STATE_CHANGE = "stateChange";
    public static final String EVENT_VALUE_CHANGE = "valueChange";
    protected String id;
    protected String name;
    protected String caption;
    protected Font font;
    protected Color color;
    protected Color backgroundColor;
    protected boolean disabled = false;
    protected boolean readOnly = false;
    protected boolean visible = true;
    private Map<String, Object> extraAttributes = new HashMap<String, Object>();
    private Map<String, List<EventListener>> eventListeners = new HashMap<String, List<EventListener>>();
    private Object model;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Font getFont() {
        return this.font;
    }

    public Font getFont(boolean createIfNull) {
        if (this.font == null && createIfNull) {
            this.font = new Font();
        }
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Map<String, Object> getExtraAttributes() {
        return this.extraAttributes;
    }

    public Object getExtraAttribute(String name) {
        return this.extraAttributes.get(name);
    }

    public void setExtraAttribute(String name, Object value) {
        this.extraAttributes.put(name, value);
    }

    public void removeExtraAttribute(String name) {
        this.extraAttributes.remove(name);
    }

    public String toString() {
        return String.format("%-10s%-30s%-30s%-30s", this.isWindow(), ((Object)((Object)this)).getClass().getSimpleName(), this.name, this.caption);
    }

    public void addChild(Component comp) {
        super.addChild((TreeNode)comp);
        this.notifyEventListeners(EVENT_STATE_CHANGE);
    }

    public void addChild(Component uic, boolean autoremovePackingCase) {
        if (autoremovePackingCase && uic instanceof PackingCase) {
            for (Component c : uic.getChildrenComponents()) {
                this.addChild(c);
            }
        } else {
            this.addChild(uic);
        }
    }

    public void addChildren(Component[] uics) {
        for (Component uic : uics) {
            this.addChild(uic);
        }
    }

    public void removeChild(Component uic) {
        super.removeChild((TreeNode)uic);
        this.notifyEventListeners(EVENT_STATE_CHANGE);
    }

    public Component getChildComponentByName(final String name) {
        Component rslt = this.tranverse(new Find(){

            @Override
            public boolean find(Component uic, int depth) {
                if (uic.name != null) {
                    return uic.name.equals(name);
                }
                return false;
            }
        }, 0);
        if (rslt != null) {
            return rslt;
        }
        throw new RuntimeException("getChildComponentByName not found name:" + name);
    }

    public List<Component> getChildrenComponents() {
        ArrayList<Component> rslt = new ArrayList<Component>();
        for (TreeNode tn : this.getChildren()) {
            Component uic = (Component)tn;
            rslt.add(uic);
        }
        return rslt;
    }

    public Component getChildComponentById(final String id) {
        Component rslt = this.tranverse(new Find(){

            @Override
            public boolean find(Component uic, int depth) {
                if (uic.id != null) {
                    return uic.id.equals(id);
                }
                return false;
            }
        }, 0);
        if (rslt != null) {
            return rslt;
        }
        throw new RuntimeException("getChildComponentById not found id:" + id + " under component:" + this.id);
    }

    protected Component tranverse(Find find, int depth) {
        if (find.find(this, depth)) {
            return this;
        }
        for (TreeNode tn : this.getChildren()) {
            Component uic = (Component)tn;
            Component rslt = uic.tranverse(find, depth + 1);
            if (rslt == null) continue;
            return rslt;
        }
        return null;
    }

    public Window findWindow() {
        if (this.isWindow()) {
            return (Window)this;
        }
        Component parent = (Component)this.getParent();
        if (parent != null) {
            return parent.findWindow();
        }
        return null;
    }

    public boolean isWindow() {
        return Window.class.isInstance((Object)this);
    }

    protected Component getComponentByClass(Class clazz) {
        System.out.println("getComponentByClass()" + (Object)((Object)this));
        if (clazz.isInstance((Object)this)) {
            System.out.println("getComponentByClass() -- Found");
            return this;
        }
        System.out.println("getComponentByClass() -- Keep looking for");
        Component p = (Component)this.getParent();
        if (p == null) {
            System.out.println("getComponentByClass() -- not found until parent null");
            return null;
        }
        System.out.println("getComponentByClass() -- try to find its parent");
        return p.getComponentByClass(clazz);
    }

    public Window getWindow() {
        Component uic = this.getComponentByClass(Window.class);
        if (uic != null) {
            return (Window)uic;
        }
        throw new RuntimeException("the root node is not a Window.");
    }

    public Object getModel() {
        return this.model;
    }

    public void setModel(Object model) {
        this.model = model;
    }

    public void setModel(Object model, boolean updateView) {
        this.setModel(model);
        if (updateView) {
            this.updateView();
        }
    }

    public void updateModel() {
        this.notifyEventListeners(EVENT_STATE_CHANGE);
        for (TreeNode tn : this.getChildren()) {
            Component comp = (Component)tn;
            comp.updateModel();
        }
    }

    public void updateView() {
        this.notifyEventListeners(EVENT_BEFORE_UPDATE_VIEW);
        for (Component child : this.getChildrenComponents()) {
            child.updateView();
        }
    }

    public abstract Object accept(Visitor var1);

    public void addEventListener(String event, EventListener listener) {
        List<EventListener> list = this.eventListeners.get(event);
        if (list == null) {
            list = new ArrayList<EventListener>();
            this.eventListeners.put(event, list);
        }
        list.add(listener);
    }

    public void removeEventListener(String event, EventListener listener) {
        List<EventListener> list = this.eventListeners.get(event);
        if (list != null) {
            list.remove(listener);
        }
    }

    public boolean existsEventListener(String event, EventListener listener) {
        List<EventListener> list = this.eventListeners.get(event);
        return list != null && list.contains(listener);
    }

    public void clearEventListener() {
        this.eventListeners.clear();
    }

    public boolean containsListener(String event) {
        List<EventListener> list = this.eventListeners.get(event);
        return list != null && !list.isEmpty();
    }

    public void notifyEventListeners(String event) {
        this.notifyEventListeners(event, new Object[0]);
    }

    public void notifyEventListeners(String event, Object ... parameters) {
        List<EventListener> list = this.eventListeners.get(event);
        if (list != null) {
            for (EventListener el : list) {
                el.process(this, event, parameters);
            }
        }
    }

    public void forceUpdateView() {
        this.notifyEventListeners(EVENT_STATE_CHANGE);
    }

    public void destroy() {
    }

    static interface Find {
        public boolean find(Component var1, int var2);
    }
}

