package net.abstractfactory.plum.view.event;

import net.abstractfactory.plum.view.component.Component;

/**
 * for value related component, such as text field, this event is useful.
 * 
 * @author jack
 *
 * @param <T>
 */
public abstract class ValueChangeListener<T> extends AbstractEventListener {
	@Override
	public void process(Component source, String eventName, Object[] parameters) {
		onValueChange((T) parameters[0], (T) parameters[1]);
	}

	public abstract void onValueChange(T oldValue, T newValue);
}