package net.abstractfactory.plum.view.component.window;

import java.util.HashMap;
import java.util.Map;

/**
 * a group of info of a business object
 * 
 * @author jack
 * 
 */
public class BusinessObject {

	/*
	 * the class, mostly the interface class, from which can read PLUM
	 * annotations
	 */
	private Class clazz;

	/**
	 * if the clazz is a generic class, here is the map
	 */
	private Map<String, Class> genericTypeMap;

	/**
	 * the real instance of the business object
	 */
	private Object instance;

	public BusinessObject(Class clazz, Object instance) {
		this.clazz = clazz;
		this.instance = instance;
	}

	public BusinessObject(Class clazz, Map<String, Class> genericTypeMap,
			Object instance) {
		this.clazz = clazz;
		this.genericTypeMap = genericTypeMap;
		this.instance = instance;
	}

	public BusinessObject(Class clazz, String typeName, Class typeClass,
			Object instance) {
		this.clazz = clazz;

		this.genericTypeMap = new HashMap<String, Class>();
		genericTypeMap.put(typeName, typeClass);

		this.instance = instance;
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append(getClazz().getSimpleName());

		if (getGenericTypeMap() != null) {
			sb.append("(");
			for (Class cls : getGenericTypeMap().values()) {

				sb.append(cls.getSimpleName());
				sb.append(",");
			}
			sb.setLength(sb.length() - 1);
			sb.append(")");
		}

		return sb.toString();
	}

	public Class getClazz() {
		return clazz;
	}

	public void setClazz(Class clazz) {
		this.clazz = clazz;
	}

	public Map<String, Class> getGenericTypeMap() {
		return genericTypeMap;
	}

	public void setGenericTypeMap(Map<String, Class> genericTypeMap) {
		this.genericTypeMap = genericTypeMap;
	}

	public Object getInstance() {
		return instance;
	}

	public void setInstance(Object instance) {
		this.instance = instance;
	}
}
