package net.abstractfactory.plum.view.component.menu;

import net.abstractfactory.common.TreeNode;
import net.abstractfactory.plum.model.ViewAction;
import net.abstractfactory.plum.view.Visitor;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.event.EventListener;

public class MenuItem extends Component {
	public static final String EVENT_CLICK = "click";
	
	public void addClickListener(EventListener listener) {
		addEventListener(EVENT_CLICK, listener);
	}

	public void click() {
		notifyEventListeners(EVENT_CLICK, null);
	}

	@Override
	public Object accept(Visitor visitor) {
		return visitor.visit(this);
	}

	@Override
	public void updateView() {

		super.updateView();

		ViewAction model = (ViewAction) getModel();
		if (model != null) {
			setName(model.getName());
			setCaption(model.getCaption());
			
			clearEventListener();
			addClickListener(model.getActionListener());
		}
	}

	/**
	 * the depth from menu bar.
	 */
	public int getMenuDepth() {
		int i = 0;
		TreeNode node = this;
		while (true) {
			node = node.getParent();
			i++;

			if (node instanceof MenuBar)
				break;

			if (i == 10)
				throw new RuntimeException("menu depth should less than 10.");
		}

		return i;
	}

}
