package net.abstractfactory.plum.view.component.listbox;

import net.abstractfactory.plum.view.Visitor;
import net.abstractfactory.plum.view._abstract.components.listbox.option.Options;
import net.abstractfactory.plum.view.component.Component;

/**
 * text-based dropdown.
 * 
 * @author jack
 *
 */
public class RadioField extends Component implements SingleSelector {
	private Options options;
	private int selectedIndex = -1;

	@Override
	public Object accept(Visitor visitor) {
		return visitor.visit(this);
	}

	@Override
	public void setOptions(Options objects) {
		this.options = objects;
	}

	@Override
	public Options getOptions() {

		return options;
	}


	@Override
	public int getSelectedIndex() {

		return selectedIndex;
	}

	@Override
	public void setSelectedIndex(int index) {

		Object old = getSelectedValue();

		this.selectedIndex = index;

		Object newVal = getSelectedValue();
		notifyEventListeners(EVENT_STATE_CHANGE);
		notifyEventListeners(EVENT_VALUE_CHANGE, old, newVal);
	}

	@Override
	public Object getSelectedValue() {
		if (selectedIndex >= 0)
			return options.get(selectedIndex);
		else
			return null;
	}

	@Override
	public void setSelectedValue(Object value) {

		Object old = getSelectedValue();

		int index = options.indexOf(value);
		if (index >= 0) {
			setSelectedIndex(index);

			notifyEventListeners(EVENT_STATE_CHANGE);
			notifyEventListeners(EVENT_VALUE_CHANGE, old, value);
		}
	}

}
