package net.abstractfactory.plum.view.component.listbox;

import java.lang.reflect.Method;

import org.apache.log4j.Logger;

public class IdNameExtractorImpl implements IdNameExtractor {
	private static Logger logger = Logger.getLogger(IdNameExtractorImpl.class);

	private String idFieldName;
	private String nameFieldName;

	public IdNameExtractorImpl(String idFieldName, String nameFieldName) {
		this.idFieldName = idFieldName;
		this.nameFieldName = nameFieldName;

		char newChar = Character.toUpperCase(idFieldName.charAt(0));
		this.idFieldName = newChar + idFieldName.substring(1);

		newChar = Character.toUpperCase(nameFieldName.charAt(0));
		this.nameFieldName = newChar + nameFieldName.substring(1);

	}

	@Override
	public Object getId(Object o) {

		try {

			Method m = o.getClass()
					.getDeclaredMethod("get" + idFieldName, null);

			Object s = m.invoke(o, null);

			return s;
		} catch (Exception e) {
			logger.error(e);

			throw new RuntimeException(e);

		}

	}

	@Override
	public Object getName(Object o) {

		try {
			Method m = o.getClass().getDeclaredMethod("get" + nameFieldName,
					null);

			Object s = m.invoke(o, null);

			return s;
		} catch (Exception e) {
			// TODO Auto-generated catch block

			throw new RuntimeException(e);
		}

	}
}
