package net.abstractfactory.plum.view.component.containers.window;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/**
 * WindowManager is not global, it only take care of one session of windows
 * 
 * @author HZ00260
 * 
 */
public class WindowManager {
	private org.apache.log4j.Logger logger = org.apache.log4j.Logger
			.getLogger(getClass());;

	private Screen screen = new Screen();

	public WindowManager() {
		// TODO Auto-generated constructor stub
	}

	/**
	 * it maintains all the window in its Z-index order.<br>
	 * the first one on the front side.
	 */
	protected LinkedList<Window> zOrderedWindows = new LinkedList<Window>();

	public void register(Window window) {
		logger.debug("window registered:" + window.title);
		zOrderedWindows.addLast(window);
		
		screen.addChild(window);

		print();
	}

	public MainWindow getMainWindow() {
		return (MainWindow) zOrderedWindows.getFirst();
	}

	public List<Window> getAllWindows() {
		return zOrderedWindows;
	}

	/**
	 * 0 is behind most.
	 * 
	 * @param window
	 * @return
	 */
	public int getZIndex(Window window) {
		return zOrderedWindows.indexOf(window);
	}

	public void unregister(Window window) {
		logger.debug("window unregistered:" + window.title);
		zOrderedWindows.remove(window);
		
		screen.removeChild(window);
	}

	public void bringFront(Window window) {
		zOrderedWindows.remove(window);
		zOrderedWindows.addLast(window);
	}

	private Window getFontWindow() {
		return zOrderedWindows.getLast();
	}

	public Window getVisibleFontWindow() {

		Iterator<Window> it = zOrderedWindows.iterator();
		Window window = null;
		Window lastVisibleWindow = null;
		while (it.hasNext()) {
			window = it.next();
			if (window.isVisible()) {
				lastVisibleWindow = window;
			}
		}

		if (lastVisibleWindow == null)
			throw new RuntimeException(
					"getVisibleFontWindow(), can not find a visible window");

		return lastVisibleWindow;
	}

	public Screen getScreen() {
		return screen;
	}
	
	public void print() {
		logger.debug("WindowManager Info, size=" + zOrderedWindows.size());
		Iterator<Window> it = zOrderedWindows.iterator();

		int i = 0;
		while (it.hasNext()) {
			Window w = it.next();
			logger.debug(String.format("window[%d] name=%s, title=%s ", i,
					w.getName(), w.getTitle()));

			i++;
		}
	}
}
