package net.abstractfactory.plum.view.component.containers.window;

import net.abstractfactory.plum.view.component.Button;
import net.abstractfactory.plum.view.component.ClickEventListener;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.Label;
import net.abstractfactory.plum.view.component.containers.layout.HorizontalBox;
import net.abstractfactory.plum.view.component.containers.layout.VerticalBox;

public class NotificationBox extends Dialog {
	HorizontalBox container;
	Label lblText;
	Button btnOk;

	VerticalBox body;
	HorizontalBox footer;

	public NotificationBox(String text) {
		super();

		init();

		lblText = new Label();
		lblText.setText(text);

		container.addChild(lblText);

	}

	public NotificationBox(Component view) {
		super();

		init();

		container.addChild(view);

	}

	private void init() {
		body = new VerticalBox();
		addChild(body);
		footer = new HorizontalBox();
		addChild(footer);

		container = new HorizontalBox();
		body.addChild(container);

		btnOk = new Button();
		btnOk.setCaption("OK");
		btnOk.addClickListener(new ClickEventListener() {
			@Override
			public void onClick(Component source) {
				closeDialog(ModalResult.OK);

			}
		});
		footer.addChild(btnOk);
	}

	public HorizontalBox getContainer() {
		return container;
	}

	public void setContainer(HorizontalBox container) {
		this.container = container;
	}

}
