package net.abstractfactory.plum.view.component.containers.window;

import net.abstractfactory.plum.view.component.containers.Panel;
import net.abstractfactory.plum.view.component.menu.MenuBar;

/**
 * It is a special window class. it will has its logo,title,head panel, content
 * panel, even navigate panel,...<todo>
 * 
 * @author HZ00260
 * 
 */
public class MainWindow extends Window {

	protected Panel headPanel;
	protected Panel menuPanel;

	protected Panel bodyPanel;
	protected Panel footPanel;

	public MainWindow() {

		eventThread = new WindowEventThread(this, null);
		setEventThread(eventThread);
		eventThread.start();

		init();
	}

	private void init() {

		headPanel = new Panel();

		// the contentPanel is created in the super class Window
		// contentPanel = (Panel) uiComponentBuilder
		// .createNonFieldComponent(StandardUIComponentType.Panel);

		headPanel.setName("headPanel");

		contentPanel.addChild(headPanel);

		menuPanel = new Panel();
		headPanel.addChild(menuPanel);

		bodyPanel = new Panel();
		contentPanel.addChild(bodyPanel);

		footPanel = new Panel();
		contentPanel.addChild(footPanel);

	}

	public Panel getHeadPanel() {
		return headPanel;
	}

	public void setHeadPanel(Panel headPanel) {
		if (this.headPanel != null)
			removeChild(this.headPanel);

		this.headPanel = headPanel;
		addChild(headPanel);
	}

	public Panel getMenuPanel() {
		return menuPanel;
	}

	public void setContentPanel(Panel contentPanel) {
		if (this.contentPanel != null)
			removeChild(this.contentPanel);

		this.contentPanel = contentPanel;
		addChild(contentPanel);
	}

	public Panel getBodyPanel() {
		return bodyPanel;
	}
	
	public Panel getFootPanel() {
		return footPanel;
	}
}
