package net.abstractfactory.plum.view.component.containers.window;

import java.util.concurrent.FutureTask;
import java.util.concurrent.Semaphore;

import net.abstractfactory.common.Context;
import net.abstractfactory.plum.view.Visitor;
import net.abstractfactory.plum.view.context.ViewSessionContextUtils;

public class Dialog extends Window {
	/**
	 * the one to be active window.
	 */
	private Semaphore active = new Semaphore(0);

	protected boolean modal;

	protected ModalResult modalResult = ModalResult.CANCEL;

	public Dialog() {
		super();

		WindowEventThread thread = (WindowEventThread) Thread.currentThread();
		eventThread = new WindowEventThread(this, thread);
		// copy context from parent context, for InteractionManager

		eventThread.start();
	}

	public boolean isModal() {
		return modal;
	}

	public void setModal(boolean modal) {
		this.modal = modal;
	}

	public ModalResult getModalResult() {
		return modalResult;
	}

	public void setModalResult(ModalResult modalResult) {
		this.modalResult = modalResult;

	}

	/**
	 * set result, close it. exit thread.
	 * 
	 * @param modalResult
	 */
	public void closeDialog(ModalResult modalResult) {
		setModalResult(modalResult);
		closeWindow();
	}

	/**
	 * free dialog resource
	 */
	protected void closeDialog() {
		//hide so that the event thread will skip the ViewRfreshTask		
		

		// resume caller thread
		active.release();
	}

	@Override
	public void closeWindow() {
		super.closeWindow();
		closeDialog();

	}

	/**
	 * suspend current thread,
	 */
	public ModalResult showModal(Window parent) {

		parent.addChildWindow(this);
		getWindowManager().bringFront(this);
		show();

		Context sessionContext = EventThreadContext.getCurrentThreadContext()
				.getSessionContext();

		FutureTask<Object> refreshViewTask = ViewSessionContextUtils
				.takeRefreshViewFutureTask(sessionContext);

		// move refreshViewTask to thread of dialog, mostly it will be executed
		// immediately.
		/*
		 * if (refreshViewTask != null) {
		 * getEventThread().setRefreshViewTask(refreshViewTask);
		 * getEventThread().addEvent(new TimeToRefreshViewEvent()); }
		 */

		// to reduce thread overhead, run task here.
		if (refreshViewTask != null) {
			refreshViewTask.run();
		}

		try {
			// pause caller thread.
			active.acquire();

			return modalResult;
		} catch (InterruptedException e) {

			throw new RuntimeException(e);
		}
	}

	@Override
	public Object accept(Visitor visitor) {

		return visitor.visit(this);

	}
}
