package net.abstractfactory.plum.view.component.containers.window;

import net.abstractfactory.plum.view.component.Button;
import net.abstractfactory.plum.view.component.ClickEventListener;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.Label;
import net.abstractfactory.plum.view.event.AbstractEventListener;

public class ConfirmationBox extends Dialog {
	Label lblText;
	Button btnYes;
	Button btnNo;
	Button btnCancel;

	public ConfirmationBox(String text) {
		super();

		lblText = new Label();
		lblText.setText(text);

		addChild(lblText);

		btnYes = new Button();
		btnYes.setCaption("Yes");
		btnYes.addClickListener(new ClickEventListener() {

			@Override
			public void onClick(Component source) {
				closeDialog(ModalResult.YES);
			}
		});
		addChild(btnYes);

		btnNo = new Button();
		btnNo.setCaption("No");
		btnNo.addClickListener(new ClickEventListener() {
			@Override
			public void onClick(Component source) {

				closeDialog(ModalResult.NO);

			}
		});
		addChild(btnNo);

		btnCancel = new Button();
		btnCancel.setCaption("Cancel");
		btnCancel.addClickListener(new ClickEventListener() {

			@Override
			public void onClick(Component source) {

				closeDialog(ModalResult.CANCEL);

			}
		});
		addChild(btnCancel);

	}

}
