package net.abstractfactory.plum.view.component;

import net.abstractfactory.common.CompareUtils;
import net.abstractfactory.plum.view.Visitor;

/**
 * text box as a classical component, its attribute maxLength and text. That
 * means without rich domain field or target UI component, it is stand alone,
 * testable.
 * 
 * @author HZ00260
 * 
 */
public class TextBox extends Component {
	protected Integer maxLength;
	private String text;

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

	public void setText(String text, boolean notify) {

		Object oldValue = this.text;
		Object newValue = text;

		this.text = text;

		if (notify && !CompareUtils.equals(oldValue, newValue)) {
			notifyEventListeners(EVENT_STATE_CHANGE);
			notifyEventListeners(EVENT_VALUE_CHANGE, oldValue, newValue);
		}
	}

	@Override
	public Object accept(Visitor visitor) {
		return visitor.visit(this);
	}
}
