package net.abstractfactory.plum.view.component;

import net.abstractfactory.common.CompareUtils;
import net.abstractfactory.plum.view.Visitor;

/**
 * text box as a classical component, has it's model, such as maxLength and
 * text. That means without rich domain field or target UI component, it is
 * stand alone, testable.
 * 
 * @author HZ00260
 * 
 */
public class PasswordBox extends Component {
	protected Integer maxLength;
	private String password;

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public void setPassword(String password, boolean notify) {
		Object oldValue = this.password;
		Object newValue = password;

		this.password = password;

		if (notify && !CompareUtils.equals(oldValue, newValue)) {

			notifyEventListeners(EVENT_STATE_CHANGE);
			notifyEventListeners(EVENT_VALUE_CHANGE, new Object[] { oldValue,
					newValue });
		}
	}

	@Override
	public Object accept(Visitor visitor) {
		return visitor.visit(this);
	}
}
