package net.abstractfactory.plum.view.component;

import java.util.List;

import net.abstractfactory.plum.view.Visitor;
import net.abstractfactory.plum.view.component.containers.layout.HorizontalBox;
import net.abstractfactory.plum.view.component.containers.layout.VerticalBox;

public class ListView extends VerticalBox {
	private List<Component> items;

	public ListView() {

	}

	void recreateUI() {
		removeAllChildren();

		Label label = new Label();
		addChild(label);

		for (Component item : items) {
			HorizontalBox row = new HorizontalBox();
			row.addChild(item);
			addChild(row);
		}

	}

	public void setItems(List items) {
		this.items = items;

		recreateUI();
	}

	public void setItems(List items, boolean notify) {
		List oldItems = this.items;
		List newItems = items;
		this.items = items;

		recreateUI();

		if (notify) {
			notifyEventListeners(EVENT_STATE_CHANGE);
			notifyEventListeners(EVENT_VALUE_CHANGE, oldItems, newItems);
		}
	}

	@Override
	public Object accept(Visitor visitor) {
		return visitor.visit(this);
	}
}
