package net.abstractfactory.plum.view.component;

import java.util.HashSet;
import java.util.Set;

import net.abstractfactory.plum.view.Visitor;
import net.abstractfactory.plum.view._abstract.components.listbox.option.Options;
import net.abstractfactory.plum.view.component.listbox.MultipleSelector;
import net.abstractfactory.plum.view.component.listbox.SelectionMode;
import net.abstractfactory.plum.view.component.listbox.SingleSelector;

/**
 * ListBox must have list items. Items are entities. id, name pair is common.
 * id, description pair, description contains other information besides name id,
 * name, xxx, fff, ... etc. it is a table actually.
 * 
 * @author HZ00260
 * 
 */
public class ListBox extends Component implements SingleSelector,
		MultipleSelector<Object> {

	protected Options options;

	// for single mode
	private int selectedIndex = -1;

	// for multiple mode
	protected Set<Integer> selectedIndices = new HashSet<Integer>();

	// mode
	protected SelectionMode selectionMode;

	public void setOptions(Options options) {
		this.options = options;
	}

	@Override
	public Options getOptions() {

		return options;
	}

	public ListBox() {

	}

	public int getSelectedIndex() {

		return selectedIndex;
	}

	public void setSelectedIndex(int index) {
		Object old = getSelectedValue();

		this.selectedIndex = index;

		Object newVal = getSelectedValue();
		notifyEventListeners(EVENT_STATE_CHANGE);
		notifyEventListeners(EVENT_VALUE_CHANGE, old, newVal);
	}

	@Override
	public Object getSelectedValue() {
		if (selectedIndex < 0 || selectedIndex >= options.size())
			return null;
		else
			return options.get(selectedIndex);
	}

	@Override
	public void setSelectedValue(Object value) {
		Object old = getSelectedValue();

		int index = options.indexOf(value);
		if (index >= 0) {
			setSelectedIndex(index);

			notifyEventListeners(EVENT_STATE_CHANGE);
			notifyEventListeners(EVENT_VALUE_CHANGE, old, value);
		}
	}

	public Set<Integer> getSelectedIndices() {
		return selectedIndices;
	}

	@Override
	public void setSelectedIndices(Set<Integer> indices) {
		selectedIndices.clear();

		selectedIndices.addAll(indices);
	}

	public void setSelectedIndices(Set<Integer> indices, boolean notify) {
		Object oldValue = getSelectedValues();

		selectedIndices.clear();

		selectedIndices.addAll(indices);

		Object newValue = getSelectedValues();

		if (notify) {
			notifyEventListeners(EVENT_STATE_CHANGE);
			notifyEventListeners(EVENT_VALUE_CHANGE, oldValue, newValue);
		}
	}

	public Set<Object> getSelectedValues() {
		Set<Object> values = new HashSet<Object>();

		for (int i : selectedIndices)
			values.add(options.get(i));

		return values;
	}

	@Override
	public void setSelectedValues(Set<Object> values) {
		selectedIndices.clear();

		for (Object value : values) {
			Integer index = options.indexOf(value);
			selectedIndices.add(index);
		}

	}

	public void setSelectedValues(Set<Object> values, boolean notify) {

		Object oldValue = getSelectedValues();
		Object newValue = values;

		setSelectedValues(values);

		if (notify) {
			notifyEventListeners(EVENT_STATE_CHANGE);
			notifyEventListeners(EVENT_VALUE_CHANGE, oldValue, newValue);
		}
	}

	public SelectionMode getSelectionMode() {
		return selectionMode;
	}

	public void setSelectionMode(SelectionMode selectionMode) {
		this.selectionMode = selectionMode;
	}

	@Override
	public String toString() {
		if (options.size() == 0)
			return super.toString();

		StringBuilder sb = new StringBuilder();
		sb.append("(");
		for (int i = 0; i < options.size(); i++) {
			Object option = options.get(i);
			sb.append(option);
			sb.append("|");
		}
		sb.replace(sb.length() - 1, sb.length(), ")");

		return super.toString() + sb.toString();
	}

	@Override
	public Object accept(Visitor visitor) {
		return visitor.visit(this);
	}

}
