package net.abstractfactory.plum.view.component;

import net.abstractfactory.common.CompareUtils;
import net.abstractfactory.plum.view.Visitor;

public class Label extends Component {
	private String text;

	public Label() {

	}

	public Label(String text) {
		this.text = text;
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

	public void setText(String text, boolean notify) {

		Object oldValue = this.text;
		Object newValue = text;

		this.text = text;

		if (notify && !CompareUtils.equals(oldValue, newValue)) {
			notifyEventListeners(EVENT_STATE_CHANGE);
			notifyEventListeners(EVENT_VALUE_CHANGE, oldValue, newValue);
		}
	}

	@Override
	public Object accept(Visitor visitor) {
		return visitor.visit(this);
	}
}
