package net.abstractfactory.plum.view.component;

import net.abstractfactory.plum.input.value.image.Image;
import net.abstractfactory.plum.view.Visitor;

public class ImageView extends Component {
	private Image image;
	// px
	private int width = 0;
	private int height = 0;
	
	private long imageVersion=0;

	public Image getImage() {
		return image;
	}

	public void setImage(Image image) {
		this.image = image;
		imageVersion++;
	}

	public void setImage(Image image, boolean notify) {
		Object oldValue = this.image;
		Object newValue = image;

		this.image = image;

		if (notify) {
			notifyEventListeners(EVENT_STATE_CHANGE);
			notifyEventListeners(EVENT_VALUE_CHANGE, new Object[] { oldValue,
					newValue });
		}
	}

	public int getWidth() {
		return width;
	}

	public void setWidth(int width) {
		this.width = width;
	}

	public int getHeight() {
		return height;
	}

	public void setHeight(int height) {
		this.height = height;
	}
	
	public long getImageVersion() {
		return imageVersion;
	}

	@Override
	public Object accept(Visitor visitor) {
		return visitor.visit(this);
	}
}
