package net.abstractfactory.plum.view.component;

import net.abstractfactory.plum.input.value.File;
import net.abstractfactory.plum.view.Visitor;

public class FileView extends Component {
	private File value;

	public File getValue() {
		return value;
	}

	public void setValue(File value) {
		this.value = value;
	}

	public void setValue(File value, boolean notify) {
		File oldValue = this.value;
		File newValue = value;
		this.value = value;

		if (notify) {
			notifyEventListeners(EVENT_STATE_CHANGE);
			notifyEventListeners(EVENT_VALUE_CHANGE, oldValue, newValue);
		}
	}

	@Override
	public Object accept(Visitor visitor) {
		return visitor.visit(this);
	}
}
