package net.abstractfactory.plum.view.component;

import java.text.SimpleDateFormat;
import java.util.Date;

import net.abstractfactory.common.CompareUtils;
import net.abstractfactory.plum.view.Visitor;

public class DateTimePicker extends Component {
	private Date datetime;
	/**
	 * example: dd/MM/yyyy hh:mm:ss
	 */
	private String format = "yyyy/MM/dd hh:mm:ss";
	// private String format="yyyy/MM/dd";

	private DateTimePickerMode mode = DateTimePickerMode.BOTH;

	public Date getDatetime() {
		return datetime;
	}

	public void setDatetime(Date datetime) {
		this.datetime = datetime;
	}

	public void setDatetime(Date datetime, boolean notify) {
		Object oldValue = this.datetime;
		Object newValue = datetime;

		this.datetime = datetime;

		if (notify && !CompareUtils.equals(oldValue, newValue)) {
			notifyEventListeners(EVENT_STATE_CHANGE);
			notifyEventListeners(EVENT_VALUE_CHANGE, new Object[] { oldValue,
					newValue });
		}
	}

	public String getDateTimeString() {
		if (datetime != null)
			return new SimpleDateFormat(format).format(datetime);
		else
			return null;
	}

	public String getFormat() {
		return format;
	}

	public void setFormat(String format) {
		this.format = format;
	}

	public DateTimePickerMode getMode() {
		return mode;
	}

	public void setMode(DateTimePickerMode mode) {
		this.mode = mode;
	}

	@Override
	public Object accept(Visitor visitor) {
		return visitor.visit(this);
	}
}
