package net.abstractfactory.plum.view.component;

import net.abstractfactory.plum.view.Visitor;

public class CheckBox extends Component {
	private boolean checked;

	public void setChecked(boolean checked) {
		this.checked = checked;
	}

	public void setChecked(boolean checked, boolean notify) {
		boolean oldValue = this.checked;
		boolean newValue = checked;

		this.checked = checked;

		if (notify && oldValue != checked) {

			notifyEventListeners(EVENT_STATE_CHANGE);
			notifyEventListeners(EVENT_VALUE_CHANGE, new Object[] { oldValue,
					newValue });
		}
	}

	public Boolean isChecked() {
		return checked;
	}

	@Override
	public Object accept(Visitor visitor) {
		return visitor.visit(this);
	}
}
