package net.abstractfactory.plum.view.component;

import net.abstractfactory.plum.view.Visitor;
import net.abstractfactory.plum.view.event.EventListener;

public class Button extends Component {
	public static final String EVENT_CLICK = "click";

	public Button() {

	}

	public Button(String caption) {
		this.caption = caption;
	}
	
	public void addClickListener(EventListener listener) {
		addEventListener(EVENT_CLICK, listener);
	}
	
	public void addClickListener(ClickEventListener listener) {
		addEventListener(EVENT_CLICK, listener);
	}

	public void click() {
		notifyEventListeners(EVENT_CLICK, null);
	}

	@Override
	public Object accept(Visitor visitor) {
		return visitor.visit(this);

	}
}
