package net.abstractfactory.plum.view;

import net.abstractfactory.plum.view.component.Button;
import net.abstractfactory.plum.view.component.CheckBox;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.DateTimePicker;
import net.abstractfactory.plum.view.component.FileView;
import net.abstractfactory.plum.view.component.ImageView;
import net.abstractfactory.plum.view.component.Label;
import net.abstractfactory.plum.view.component.ListBox;
import net.abstractfactory.plum.view.component.PasswordBox;
import net.abstractfactory.plum.view.component.TextBox;
import net.abstractfactory.plum.view.component.containers.Panel;
import net.abstractfactory.plum.view.component.containers.layout.Grid;
import net.abstractfactory.plum.view.component.containers.layout.HorizontalBox;
import net.abstractfactory.plum.view.component.containers.layout.VerticalBox;
import net.abstractfactory.plum.view.component.containers.window.Dialog;
import net.abstractfactory.plum.view.component.containers.window.Screen;
import net.abstractfactory.plum.view.component.containers.window.Window;
import net.abstractfactory.plum.view.component.listbox.DropdownList;
import net.abstractfactory.plum.view.component.listbox.RadioField;
import net.abstractfactory.plum.view.component.menu.Menu;
import net.abstractfactory.plum.view.component.menu.MenuBar;
import net.abstractfactory.plum.view.component.menu.MenuItem;

/**
 * view visitor, used to generate native client DOM.
 * 
 * @author jack
 * 
 * @param <T>
 */
public interface Visitor<T> {

	/**
	 * for unimplemented sub class
	 * 
	 * @param uicomponent
	 * @return
	 */
	T visit(Component component);

	// form elements
	T visit(TextBox component);

	T visit(PasswordBox component);

	T visit(Button component);

	T visit(Label component);

	T visit(DropdownList component);

	T visit(ListBox component);

	T visit(CheckBox component);

	T visit(RadioField component);

	T visit(FileView component);

	T visit(ImageView component);

	T visit(DateTimePicker component);

	// layout
	T visit(HorizontalBox component);

	T visit(VerticalBox component);

	// container
	T visit(Panel component);

	T visit(Screen component);

	T visit(Window component);

	T visit(Dialog component);

	// layout
	T visit(Grid component);

	// menu
	T visit(MenuBar component);

	T visit(Menu component);

	T visit(MenuItem component);
}
