package net.abstractfactory.plum.model;

public abstract class AbstractAction<T> implements ViewAction {

	protected T model;

	public AbstractAction init(T model) {
		this.model = (T) model;

		return this;
	}

	protected T getModel() {
		return model;
	}

	@Override
	public String toString() {

		return String.format("%s - %s - %s", getCategory(), getName(),
				getCaption());
	}

}
