package net.abstractfactory.plum.meta.validation.validator;

public class Validator {
	/**
	 * save the target object.
	 */
	protected Object target;
	/**
	 * such as: must be number
	 */
	protected String description;
	/**
	 * pass or fail
	 */
	protected Boolean result;

	/**
	 * optional, such as: the second character of '2a10' is not a number.
	 */
	protected String additionalFailureMessage;

	public Validator() {

	}

	/**
	 * do the validate work.
	 */
	public void validate(Object target) {
		this.target = target;

		validate();
	}

	public void validate() {
		// do sth in sub class

		// not pass , default
		result = false;
	}

	@Override
	public String toString() {

		String s;
		if (additionalFailureMessage == null)
			s = "";
		else
			s = additionalFailureMessage;

		return String.format("Does '%s' meet '%s'? %s,%s", target,description, result, s);
	}

	public Boolean getResult() {
		return result;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Object getTarget() {
		return target;
	}

	public void setTarget(Object target) {
		this.target = target;
	}

}
