package net.abstractfactory.plum.meta.validation;

import java.util.ArrayList;
import java.util.List;

public class ValidationError {
	/**
	 * field or parameter name
	 */
	private String fieldName;
	private List<String> messages = new ArrayList<String>();

	public ValidationError(String fieldName, String... messages) {
		this.fieldName = fieldName;

		for (String s : messages)
			this.messages.add(s);
	}

	public void addMessage(String msg) {
		messages.add(msg);
	}

	public String getAllMessages() {
		StringBuilder sb = new StringBuilder();
		for (int i = 0; i < messages.size(); i++) {
			if (i > 0)
				sb.append(";");
			sb.append(messages.get(i));

		}

		return sb.toString();
	}

	public String getFieldName() {
		return fieldName;
	}

	public void setFieldName(String fieldName) {
		this.fieldName = fieldName;
	}

}
