   var stompClient = null;
        
        
        function connect(topic) {
        	var url = addPath(removeLastName(window.location.href), 'hello');
            var socket = new SockJS(url);
            stompClient = Stomp.over(socket);            
            stompClient.connect({}, function(frame) {
                console.log('Connected: ' + frame);
                stompClient.subscribe(topic, function(greeting){
                	var root = JSON.parse(greeting.body);
                	var jsonArray = root.data;
                	
                	var arrayLength = jsonArray.length;
                	for (var i = 0; i < arrayLength; i++) {
                	   json = jsonArray[i];
                	   showResponse(json.action, json.id, json.content, json.baseVersion, json, "websocket");                	   
                	}                	  
                	
                	//ack
                	stompClient.send("/app/pushAck", {}, JSON.stringify({ 'id': root.id }));
                });
            });
        }
        
        function disconnect() {
            if (stompClient != null) {
                stompClient.disconnect();
            }
            setConnected(false);
            console.log("Disconnected");
        }
        
        function sendName() {
            var name = document.getElementById('name').value;
            stompClient.send("/app/hello", {}, JSON.stringify({ 'name': name }));
        }
        
        function showResponse(action, id, html, baseVersion, data, method) {
        	
        	//check baseVersion        	
        	form = document.getElementById("plum-form");    
        	
        	if(baseVersion != "*" && form._plum_view_version.value != "" && form._plum_view_version.value != baseVersion)
        	{
        		msg = method+", base version of view change is wrong, current version:"+form._plum_view_version.value+", expected base version:"+baseVersion
        		if(method=="websocket"){
        			//for websocket push, just ignore the view change.
        			//console.log(msg);
        			
        			alert(msg);

            		return;
        		}
        		else{
        			alert(msg);

            		return;
        		}
        		
        	}
        	
        	if(action=="replace")
        		$("#"+id).replaceWith(html);
        	else if(action=="append")
        		$("#"+id).append(html);
        	else if(action=="remove")
        		$("#"+id).remove();
        	else if(action=="focus")
        		$("#"+id).focus();
        	else if(action=="blur")
        		$("#"+id).blur();
        	else if(action=="update_version")
        	{
        		//update view version
        		form._plum_view_version.value = data.newVersion;
        		console.debug("update_version to "+ data.newVersion);
        	}
        	
        		
        	
        	plumInitView();
        }
        
        function removeLastName(url){
        	if(url.endsWith('/')){
        		return url;
        	}else{
	        	index = url.lastIndexOf('/');
	        	return url.substring(0, index);
        	}
        }
        
        //copied from sockjs.js
        function addPath(url, path) {
        	
            var qs = url.split('?');
            
            if(!qs[0].endsWith('/'))
            {
            	path = '/' + path;
            }
            
            return qs[0] + path + (qs[1] ? '?' + qs[1] : '');
        }
        