/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.layout;

import java.util.List;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.layout.GridLayout;
import net.abstractfactory.plum.view.web.component.AbstractWebComponent;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Tag;

public class WebGridLayout
extends AbstractWebComponent {
    Element table;
    Element head;
    Element body;
    Element currentTR;
    List<Element> trList;

    public WebGridLayout(String id, Component component) {
        super(id, component);
    }

    private GridLayout getGridLayout() {
        return (GridLayout)this.component;
    }

    @Override
    public void createHtmlElement() {
        this.table = new Element(Tag.valueOf((String)"table"), "");
        this.table.attr("class", "gridLayout");
        this.body = new Element(Tag.valueOf((String)"tbody"), "");
        this.table.appendChild((Node)this.body);
        this.currentTR = new Element(Tag.valueOf((String)"tr"), "");
        this.body.appendChild((Node)this.currentTR);
        this.htmlOuterElement = this.table;
    }

    private Element createCellElement(int rowIndex) {
        Element cell = new Element(Tag.valueOf((String)"td"), "");
        return cell;
    }

    private Element getCurrentContainer(int rowIndex) {
        Element container = this.body;
        return container;
    }

    @Override
    protected Element getHtmlInnerElementForNewChild() {
        GridLayout grid = this.getGridLayout();
        int currentChildSize = this.getChildren().size();
        int currentRowIndex = (currentChildSize - 1) / grid.getCols();
        int nextChildSize = currentChildSize + 1;
        int nextRowIndex = (nextChildSize - 1) / grid.getCols();
        if (nextRowIndex > currentRowIndex) {
            this.currentTR = new Element(Tag.valueOf((String)"tr"), "");
            this.getCurrentContainer(nextRowIndex).appendChild((Node)this.currentTR);
        }
        Element cell = this.createCellElement(nextRowIndex);
        this.currentTR.appendChild((Node)cell);
        return cell;
    }
}

