/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component.tree;

import java.util.Map;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.tab.Tabs;
import net.abstractfactory.plum.view.component.tree.TreeView;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;
import org.apache.log4j.Logger;
import org.jsoup.nodes.Element;

public class WebTreeView
extends AbstractTemplateWebComponent {
    static Logger logger = Logger.getLogger(WebTreeView.class);
    private static Element componentHtmlTemplate;

    public WebTreeView(String id, Component component, Element templateTemplate) {
        super(id, component, templateTemplate);
    }

    public TreeView getTreeView() {
        return (TreeView)this.getComponent();
    }

    @Override
    public void createHtmlElement() {
        ComponentElements componentElements = this.findAndCloneElement(this.getComponentHtmlTemplate(true), true);
        this.htmlOuterElement = componentElements.getOuter();
        this.htmlInnerElement = componentElements.getInner();
    }

    protected ViewAction onNodeSelected(final int newIndex) {
        return new AbstractViewAction(WebEvent.CLICK.name()){

            public void execute(Component view) {
                Tabs tabs = (Tabs)view;
                tabs.setActiveTab(newIndex, true);
            }
        };
    }

    @Override
    public ViewAction processEvent(WebEvent event, Map<String, Object> parameters) {
        if (event == WebEvent.CLICK) {
            return null;
        }
        throw new RuntimeException("unknow event:" + event);
    }

    @Override
    public Element getComponentHtmlTemplate() {
        return componentHtmlTemplate;
    }

    @Override
    public void setComponentHtmlTemplate(Element element) {
        componentHtmlTemplate = element;
    }

    @Override
    public String getComponentType() {
        return "tree";
    }
}

