/*
 * Decompiled with CFR 0.152.
 */
package net.abstractfactory.plum.view.web.component.tree;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.abstractfactory.common.ListValueMap;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.ModifierKey;
import net.abstractfactory.plum.view.component.tree.TreeNodeView;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;
import org.apache.log4j.Logger;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.TextNode;

public class WebTreeNodeView
extends AbstractTemplateWebComponent {
    private static final String COMPONENT_NAME_LINK = "link";
    private static final String PARAMETER_NAME_KEY = "key";
    static Logger logger = Logger.getLogger(WebTreeNodeView.class);
    private static Element componentHtmlTemplate;

    public WebTreeNodeView(String id, Component component, Element themeTemplate) {
        super(id, component, themeTemplate);
    }

    public TreeNodeView getTreeNodeView() {
        return (TreeNodeView)this.getComponent();
    }

    @Override
    public void createHtmlElement() {
        ComponentElements componentElements = this.findAndCloneElement(this.getComponentHtmlTemplate(true), true);
        this.htmlOuterElement = componentElements.getOuter();
        this.htmlInnerElement = componentElements.getInner();
        Element listItemElement = this.htmlOuterElement;
        TreeNodeView nodeView = this.getTreeNodeView();
        Element linkElement = this.findElementByClass(COMPONENT_NAME_LINK);
        linkElement.attr("id", this.id);
        ((TextNode)linkElement.textNodes().get(0)).text(nodeView.getCaption());
        if (nodeView.isSelected()) {
            linkElement.addClass("jstree-clicked");
        } else {
            linkElement.removeClass("jstree-clicked");
        }
        if (nodeView.isDisabled()) {
            listItemElement.addClass("jstree-disabled");
        } else {
            listItemElement.removeClass("jstree-disabled");
        }
        if (nodeView.isLast()) {
            listItemElement.addClass("jstree-last");
        } else {
            listItemElement.removeClass("jstree-last");
        }
        if (nodeView.isLeaf()) {
            listItemElement.addClass("jstree-leaf");
        } else {
            listItemElement.removeClass("jstree-leaf");
            if (nodeView.isExpanded()) {
                listItemElement.addClass("jstree-open");
                listItemElement.removeClass("jstree-closed");
            } else {
                listItemElement.addClass("jstree-closed");
                listItemElement.removeClass("jstree-open");
            }
        }
    }

    @Override
    public Element getComponentHtmlTemplate() {
        return componentHtmlTemplate;
    }

    @Override
    public void setComponentHtmlTemplate(Element element) {
        componentHtmlTemplate = element;
    }

    protected ViewAction onClick(List<Object> keys) {
        final HashSet<ModifierKey> set = new HashSet<ModifierKey>();
        for (int j = 0; j < keys.size(); ++j) {
            String key = (String)keys.get(j);
            ModifierKey mouseEventKey = ModifierKey.valueOf((String)key.toUpperCase());
            set.add(mouseEventKey);
        }
        return new AbstractViewAction(WebEvent.CLICK.name()){

            public void execute(Component view) {
                TreeNodeView treeNodeView = (TreeNodeView)view;
                treeNodeView.click(set);
            }
        };
    }

    @Override
    public ViewAction processEvent(WebEvent event, ListValueMap<String, Object> parameters) {
        if (event == WebEvent.CLICK) {
            ArrayList keys = parameters.get((Object)PARAMETER_NAME_KEY);
            if (keys == null) {
                keys = new ArrayList();
            }
            return this.onClick(keys);
        }
        if (event == WebEvent.TOGGLE) {
            return new AbstractViewAction(event.name()){

                public void execute(Component view) {
                    TreeNodeView item = (TreeNodeView)view;
                    item.toggle();
                }
            };
        }
        throw new RuntimeException("unknow event:" + event);
    }

    @Override
    public String getComponentType() {
        return "treenode";
    }
}

